#ifndef CGEN2TAGREADPERFORMANCETEST_H
#define CGEN2TAGREADPERFORMANCETEST_H

#include "../../../ui/TabWidget.h"
#include "../../../ui/ConfigDialog.h"
#include <ui_CGen2TagReadPerformanceTest.h>

class QrfeRfePurReader;
class QrfeTagInterface;
class QrfeGen2Tag;

class QStandardItemModel;


class CGen2TagReadPerformanceTest : public TagTabWidget, ConfigDialog
{
    Q_OBJECT

public:
    CGen2TagReadPerformanceTest(QTextEdit* infoEdit, QWidget* parent);
    ~CGen2TagReadPerformanceTest();

	virtual bool init(QrfeReaderInterface* reader, QrfeTagInterface* tag);
	virtual void deinit();

	virtual bool hasExecutionCount();

private slots:
	void startButtonClicked();

	void runPerformanceTest();
	void clearValues();

	void exportResults();

	void setAttenuationLabel ( int value );

private:
	bool searchForHandle(QByteArray& handle);

	bool readIdBased(uchar memBank, ushort wordAddress, uchar wordCount, const QByteArray& passwd, QByteArray& data);
	bool readHandleBased(const QByteArray& handle, uchar memBank, ushort wordAddress, uchar wordCount, const QByteArray& passwd, QByteArray& data);

private:
	QrfeRfePurReader*						m_reader;
	QrfeGen2Tag*							m_tag;
	QWidget* 								m_parent;

	QStandardItemModel*					m_readTestValueModel;

	bool								m_measurementActive;
	bool 								m_continueMeasurement;

	QByteArray 							m_tagHandle;

    Ui::CGen2TagReadPerformanceTestClass ui;
};

#endif // CGEN2TAGREADPERFORMANCETEST_H
